﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja INF-W</title>
		<script runat="server">

    [DefaultWidth(12)]
    public enum Półrocze {
        Pierwsze = 1,
        Drugie = 2
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool zaznaczeni = false;
        [Priority(1)]
        [Caption("Pracownicy wg listy")]
        public bool Zaznaczeni {
            get { return zaznaczeni; }
            set {
                zaznaczeni = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    
    public class PrnParams : Soneta.Business.ContextBase {
        public PrnParams(Context context) : base(context) {
            SetEmpty();
        }

        int rok;
        [Required]
        [Priority(10)]
        [Caption("Raport za rok")]
        public int Rok {
            get { return rok; }
            set {
                if (value == 0)
                    SetEmpty();
                else
                    rok = value;
                OnChanged(EventArgs.Empty);
            }
        }

        Półrocze półrocze;
        [Required]
        [Priority(20)]
        [Caption("...półrocze")]
        public Półrocze Półrocze {
            get { return półrocze; }
            set {
                półrocze = value;
                OnChanged(EventArgs.Empty);
            }
        }

        void SetEmpty() {
            Date data = Date.Empty;
            if (Context.Contains(typeof(ActualDate)))
                data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            if (data == Date.Empty)
                data = Date.Today;
            int y = data.Year;
            int m = data.Month;
            if (m > 6) {
                rok = y;
                półrocze = Półrocze.Pierwsze;
            }
            else {
                rok = y - 1;
                półrocze = Półrocze.Drugie;
            }
        }
    }
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    Dictionary<object, object[]> dict = new Dictionary<object, object[]>();
    List<object> oddzialy = new List<object>();
    string title;
    
	void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["ROK"] = pars.Rok.ToString();
        ReportHeader1["PÓŁROCZE"] = CaptionAttribute.EnumToString(pars.Półrocze);
        if (srpars.Zaznaczeni)
            ReportHeader1["FILTR"] = "Wydruk dla odfiltrowanych pracowników";
        else
            ReportHeader1["FILTR"] = "";
        title = ReportHeader1.Title;

        int d = ((int)pars.Półrocze - 1) * 6;
		KadryModule kadry = KadryModule.GetInstance(dc);
        for (int i=0; i<6; i++) {
			YearMonth ym = new YearMonth(pars.Rok, i + d + 1);
            IEnumerable rows;
            if (srpars.Zaznaczeni)
                rows = (Pracownik[])dc[typeof(Pracownik[])];
            else
                rows = kadry.Pracownicy.GetNaEtatach(ym.ToFromTo(), (Wydzial)null, false, true);

            List<Pracownik> list;
            Dictionary<object, List<Pracownik>> dict2 = new Dictionary<object, List<Pracownik>>();
            if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
                Date data = ym.FirstDay;
                foreach (Pracownik pracownik in rows) {
                    PracHistoria ph = pracownik[data];
                    OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                    while (of != null) {
			            if (of.GetObjectRight() != AccessRights.Denied &&
                            of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                            break;
                        of = of.Nadrzedny;
                    }
                    if (of == null)
                        continue;
                    if (!dict2.TryGetValue(of, out list))
                        dict2.Add(of, list = new List<Pracownik>());
                    list.Add(pracownik);
                }
            }
            else {
                dict2.Add(string.Empty, list = new List<Pracownik>());
                foreach (Pracownik pracownik in rows)
                    list.Add(pracownik);
            }

		    object[] src;
            foreach (object of in dict2.Keys) {
                if (!dict.TryGetValue(of, out src))
                    dict.Add(of, src = new object[6]);
			    src[i] = dict2[of];
            }
		}

        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
    }
        
    object of;

	void OnBeforeRow(Object sender, EventArgs args) {
        of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "");

        object[] src = new object[6];
        int d = ((int)pars.Półrocze - 1) * 6;
        for (int i = 0; i < 6; i++)
            src[i] = new YearMonth(pars.Rok, i + d + 1);

		Grid1.DataSource = src;
        Grid2.DataSource = src;
    }

    void Grid1_BeforeRow(object sender, RowEventArgs arg) {
        YearMonth ym = (YearMonth)arg.Row;
        FromTo okres = ym.ToFromTo();
             
        decimal pracS = 0;
        decimal znaczny1 = 0, znaczny2 = 0, znaczny3 = 0, znacznyS = 0;
        decimal umiarkowany1 = 0, umiarkowany2 = 0, umiarkowany3 = 0, umiarkowanyS = 0;
        decimal lekki1 = 0, lekki2 = 0, lekki3 = 0, lekkiS = 0;
        
        ZPCHR zpchr = new ZPCHR(false, ym, ZPCHR.WarunkiNaliczania.PFRON);

        Set<Pracownik> pracownicy = new Set<Pracownik>();
        List<Pracownik> list = (List<Pracownik>)dict[of][(ym.Month-1) % 6];
        foreach (Pracownik p in list) {
            Pracownik pracownik = p.EtatGłówny;
            if (pracownicy.Contains(pracownik))
                continue;
            pracownicy.Add(pracownik);
            IEnumerable it = zpchr[pracownik];
            Periods okresOsoby = Periods.Empty;
            foreach (ZPCHR.OkresInfo info in it) {
                if (!info.Wchodzi)
                    continue;

                int osoby = (Periods.New(info.Okres) - okresOsoby).Days;
                okresOsoby += info.Okres;
                pracS += osoby;

                bool choroba = false;
                bool upośledzenie = false;
                bool niewidomy = false;
                switch (info.TypSchorzenia) {
                    case SzczegolneSchorzenia.ChorobaPsychiczna:
                        choroba = true;
                        break;
                    case SzczegolneSchorzenia.UpośledzenieUmysłowe:
                        upośledzenie = true;
                        break;
                    case SzczegolneSchorzenia.Niewidomy:
                        niewidomy = true;
                        break;
                }

                switch (info.STN) {
                    case StNiepełnosprawności.Brak:
                        continue;
                    case StNiepełnosprawności.Lekki:
                        lekkiS += osoby;
                        if (choroba)
                            lekki1 += osoby;
                        else if (upośledzenie)
                            lekki2 += osoby;
                        else if (niewidomy)
                            lekki3 += osoby;
                        break;
                    case StNiepełnosprawności.Umiarkowany:
                        umiarkowanyS += osoby;
                        if (choroba)
                            umiarkowany1 += osoby;
                        else if (upośledzenie)
                            umiarkowany2 += osoby;
                        else if (niewidomy)
                            umiarkowany3 += osoby;
                        break;
                    case StNiepełnosprawności.Znaczny:
                        znacznyS += osoby;
                        if (choroba)
                            znaczny1 += osoby;
                        else if (upośledzenie)
                            znaczny2 += osoby;
                        else if (niewidomy)
                            znaczny3 += osoby;
                        break;
                }
            }
        }
        if (okres.Days != 0) {
            pracS /= okres.Days;
            znaczny1 /= okres.Days; znaczny2 /= okres.Days; znaczny3 /= okres.Days; znacznyS /= okres.Days;
            umiarkowany1 /= okres.Days; umiarkowany2 /= okres.Days; umiarkowany3 /= okres.Days; umiarkowanyS /= okres.Days;
            lekki1 /= okres.Days; lekki2 /= okres.Days; lekki3 /= okres.Days; lekkiS /= okres.Days;
        }

        Grid1Pracownicy.EditValue = pracS;
        Grid1Niepełnosprawni.EditValue = znacznyS + umiarkowanyS + lekkiS;
        Grid1ZnacznyS.EditValue = znacznyS;
        Grid1Znaczny1.EditValue = znaczny1;
        Grid1Znaczny2.EditValue = znaczny2;
        Grid1Znaczny3.EditValue = znaczny3;
        Grid1UmiarkowanyS.EditValue = umiarkowanyS;
        Grid1Umiarkowany1.EditValue = umiarkowany1;
        Grid1Umiarkowany2.EditValue = umiarkowany2;
        Grid1Umiarkowany3.EditValue = umiarkowany3;
        Grid1LekkiS.EditValue = lekkiS;
        Grid1Lekki1.EditValue = lekki1;
        Grid1Lekki2.EditValue = lekki2;
        Grid1Lekki3.EditValue = lekki3;
    }    
    	
	void Grid2_BeforeRow(object sender, RowEventArgs arg) {
        YearMonth ym = (YearMonth)arg.Row;
        FromTo okres = ym.ToFromTo();

        decimal pracS = 0, etatyS = 0;
        decimal znaczny1 = 0, znaczny2 = 0, znaczny3 = 0, znacznyS = 0;
        decimal umiarkowany1 = 0, umiarkowany2 = 0, umiarkowany3 = 0, umiarkowanyS = 0;
        decimal lekki1 = 0, lekki2 = 0, lekki3 = 0, lekkiS = 0;
        decimal umiarkowany1P = 0, umiarkowany2P = 0, niepelnosprawniS = 0;
        
        ZPCHR zpchr = new ZPCHR(false, ym, ZPCHR.WarunkiNaliczania.PFRON);

        Set<Pracownik> pracownicy = new Set<Pracownik>();
        List<Pracownik> list = (List<Pracownik>)dict[of][(ym.Month-1) % 6];
        foreach (Pracownik p in list) {
            Pracownik pracownik = p.EtatGłówny;
            if (pracownicy.Contains(pracownik))
                continue;
            pracownicy.Add(pracownik);
            IEnumerable it = zpchr[pracownik];
            Periods okresOsoby = Periods.Empty;
            foreach (ZPCHR.OkresInfo info in it) {
                if (!info.Wchodzi)
                    continue;

                int osoby = (Periods.New(info.Okres) - okresOsoby).Days;
                okresOsoby += info.Okres;
                decimal etaty = (decimal)info.Wymiar * info.Okres.Days;
                pracS += osoby;
                etatyS += etaty;

                bool choroba = false;
                bool upośledzenie = false;
                bool niewidomy = false;
                switch (info.TypSchorzenia) {
                    case SzczegolneSchorzenia.ChorobaPsychiczna:
                        choroba = true;
                        break;
                    case SzczegolneSchorzenia.UpośledzenieUmysłowe:
                        upośledzenie = true;
                        break;
                    case SzczegolneSchorzenia.Niewidomy:
                        niewidomy = true;
                        break;
                }

                switch (info.STN) {
                    case StNiepełnosprawności.Brak:
                        continue;
                    case StNiepełnosprawności.Lekki:
                        niepelnosprawniS += osoby;
                        lekkiS += etaty;
                        if (choroba)
                            lekki1 += etaty;
                        else if (upośledzenie)
                            lekki2 += etaty;
                        else if (niewidomy)
                            lekki3 += etaty;
                        break;
                    case StNiepełnosprawności.Umiarkowany:
                        niepelnosprawniS += osoby;
                        umiarkowanyS += etaty;
                        if (choroba)
                            { umiarkowany1 += etaty; umiarkowany1P += osoby; }
                        else if (upośledzenie)
                            { umiarkowany2 += etaty; umiarkowany2P += osoby; }
                        else if (niewidomy)
                            umiarkowany3 += etaty;
                        break;
                    case StNiepełnosprawności.Znaczny:
                        niepelnosprawniS += osoby;
                        znacznyS += etaty;
                        if (choroba)
                            znaczny1 += etaty;
                        else if (upośledzenie)
                            znaczny2 += etaty;
                        else if (niewidomy)
                            znaczny3 += etaty;
                        break;
                }
            }
        }
        if (okres.Days != 0) {
            pracS /= okres.Days; etatyS /= okres.Days;
            znaczny1 /= okres.Days; znaczny2 /= okres.Days; znaczny3 /= okres.Days; znacznyS /= okres.Days;
            umiarkowany1 /= okres.Days; umiarkowany2 /= okres.Days; umiarkowany3 /= okres.Days; umiarkowanyS /= okres.Days;
            lekki1 /= okres.Days; lekki2 /= okres.Days; lekki3 /= okres.Days; lekkiS /= okres.Days;
            umiarkowany1P /= okres.Days; umiarkowany2P /= okres.Days; niepelnosprawniS /= okres.Days;
        }
        
        Grid2Etaty.EditValue = etatyS;
        Grid2EtatyNiepełnosprawni.EditValue = znacznyS + umiarkowanyS + lekkiS;
        Grid2ZnacznyS.EditValue = znacznyS;
        Grid2Znaczny1.EditValue = znaczny1;
        Grid2Znaczny2.EditValue = znaczny2;
        Grid2Znaczny3.EditValue = znaczny3;
        Grid2UmiarkowanyS.EditValue = umiarkowanyS;
        Grid2Umiarkowany1.EditValue = umiarkowany1;
        Grid2Umiarkowany2.EditValue = umiarkowany2;
        Grid2Umiarkowany3.EditValue = umiarkowany3;
        Grid2LekkiS.EditValue = lekkiS;
        Grid2Lekki1.EditValue = lekki1;
        Grid2Lekki2.EditValue = lekki2;
        Grid2Lekki3.EditValue = lekki3;

        if (etatyS != 0m)
            Wsk1.EditValue = (znacznyS + umiarkowanyS + lekkiS) / etatyS;
        if (etatyS != 0m)
            Wsk2.EditValue = (znacznyS + umiarkowanyS) / etatyS;
        if (etatyS != 0m)
            Wsk3.EditValue = (lekki1 + znaczny1 + znaczny2 + znaczny3 + umiarkowany1 + umiarkowany2 + umiarkowany3) / etatyS;
        if (pracS != 0m)
            Wsk4.EditValue = niepelnosprawniS / pracS;
        if (pracS != 0m)
            Wsk5.EditValue = (umiarkowany1P + umiarkowany2P) / pracS;
    }
	
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaINFW" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" Landscape="true"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
                <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA DLA DEKLARACJI INF-W wg PFRON|</strong>Raport za rok: <strong>%ROK%|</strong>Półrocze: <strong>%PÓŁROCZE%|%FILTR%|%ODDZIAL%"
				    runat="server"></cc1:reportheader>
                <FONT face="Tahoma" size="2">
			    <p>D1. Zatrudnienie osób niepełnosprawnych w osobach
                <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				    <Columns>
					    <ea:GridColumn Align="Center" Width="7" DataMember="Month" Caption="Miesiąc" Format="{0:00}"></ea:GridColumn>					
                        <ea:GridColumn Align="Right" ID="Grid1Pracownicy" Caption="Ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid1Niepełnosprawni" Caption="Niepełnospr." HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid1ZnacznyS" Caption="Znaczny~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid1Znaczny1" Caption="Znaczny~|psychicznie chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid1Znaczny2" Caption="Znaczny~|upośledzeni umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid1Znaczny3" Caption="Znaczny~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>                	
                        <ea:GridColumn Align="Right" ID="Grid1UmiarkowanyS" Caption="Umiarkowany~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" ID="Grid1Umiarkowany1" Caption="Umiarkowany~|psychicznie chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" ID="Grid1Umiarkowany2" Caption="Umiarkowany~|upośledzeni umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" ID="Grid1Umiarkowany3" Caption="Umiarkowany~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>                    
                        <ea:GridColumn Align="Right" ID="Grid1LekkiS" Caption="Lekki~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>                    
                        <ea:GridColumn Align="Right" ID="Grid1Lekki1" Caption="Lekki~|psychicznie chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>                    
                        <ea:GridColumn Align="Right" ID="Grid1Lekki2" Caption="Lekki~|upośledzeni umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>                    
                        <ea:GridColumn Align="Right" ID="Grid1Lekki3" Caption="Lekki~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>                    				
                    </Columns>
			    </ea:grid>
                </p>
                <p>D2. Zatrudnienie osób niepełnosprawnych w etatach
			    <ea:grid id="Grid2" runat="server" onbeforerow="Grid2_BeforeRow">
				    <Columns>
					    <ea:GridColumn Align="Center" Width="7" DataMember="Month" Caption="Miesiąc" Format="{0:00}"></ea:GridColumn>					
                        <ea:GridColumn Align="Right" ID="Grid2Etaty" Caption="Ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2EtatyNiepełnosprawni" Caption="Niepełnos." HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2ZnacznyS" Caption="Znaczny~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Znaczny1" Caption="Znaczny~|psych. chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Znaczny2" Caption="Znaczny~|upośl. umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Znaczny3" Caption="Znaczny~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2UmiarkowanyS" Caption="Umiarkowany~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Umiarkowany1" Caption="Umiarkowany~|psych. chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Umiarkowany2" Caption="Umiarkowany~|upośl. umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Umiarkowany3" Caption="Umiarkowany~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2LekkiS" Caption="Lekki~|ogółem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Lekki1" Caption="Lekki~|psych. chorzy" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Lekki2" Caption="Lekki~|upośl. umysłowo" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" ID="Grid2Lekki3" Caption="Lekki~|niewidomi" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Width="7" ID="Wsk1" Caption="Wsk.1" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Width="7" ID="Wsk2" Caption="Wsk.2" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Width="7" ID="Wsk3" Caption="Wsk.3" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Width="7" ID="Wsk4" Caption="Wsk.4" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Width="7" ID="Wsk5" Caption="Wsk.5" HideZero="True" Format="{0:n}"></ea:GridColumn>					
				    </Columns>
                </ea:grid>
			    </p>
                </FONT>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
